class VideoGenerateExample {
  /**
   * 合成视频
   *
   */
  create() {
    this.$axios
      .post(`/api/2dvh/v1/material/video/create`, {
        videoName: "示例视频",
        param: "{\"version\":\"0.0.4\",\"resolution\":[1080,1920],\"bit_rate\":16,\"frame_rate\":25,\"watermark\":{\"show\":true,\"content\":\"示例视频\"},\"digital_role\":{\"id\":3964,\"face_feature_id\":\"0401_chenying_s1\",\"name\":\"0401_chenying_s1\",\"url\":\"https://dwg-aigc-paas.oss-cn-hangzhou.aliyuncs.com/materials/77/0401_chenying_s1_20230427133135306.zip\",\"position\":{\"x\":0,\"y\":0},\"scale\":1.0},\"tts_config\":{\"id\":\"nina\",\"name\":\"Nina\",\"vendor_id\":3,\"language\":\"zh-CN\",\"pitch_offset\":0.0,\"speed_ratio\":1,\"volume\":100},\"tts_query\":{\"content\":\"丝绸之路是一条连接东西方的古老商路，在这条路上，东西方通过贸易和文化交流，促进了不同文明的不断融合。 历史上张骞出使西域，开启了最早的丝绸之路，从此丝绸之路上的商人一次次穿越沙漠和山脉进行通商往来。 中国的丝绸、瓷器、茶叶，以及印度的佛教、希腊的哲学等都在这条路上得到充分地传承和发展。\",\"ssml\":false},\"backgrounds\":[{\"type\":0,\"name\":\"背景\",\"url\":\"http://dwg-aigc-paas.oss-cn-hangzhou.aliyuncs.com/test/background.png\",\"rect\":[0,0,1080,1920],\"cycle\":false,\"start\":0,\"duration\":-1}],\"foregrounds\":[{\"type\":0,\"name\":\"前景\",\"url\":\"http://dwg-aigc-paas.oss-cn-hangzhou.aliyuncs.com/test/frontgroud.png\",\"rect\":[0,1359,1092,561],\"cycle\":false,\"start\":0,\"duration\":-1}],\"foreground-texts\":[{\"text\":\"丝绸之路介绍\",\"font_size\":20,\"font_family\":\"Noto Sans S Chinese Black\",\"position\":{\"x\":100,\"y\":200},\"rgba\":[100,200,100,100]}]}",  // 视频合成参数（该参数为json转义后的字符串）
      })
      .then((res) => {
        const { code, message } = res;
        if (code !== 0) {
          this.$message.error(message);
          return;
        }
        this.$message.success("创建成功");
      })
      .finally(() => {
      });
  }

  /**
   * 获取任务列表数据
   */
  getTableData() {
    this.$axios
      .post(`/api/2dvh/v1/task/listByAccount`, {
        algoType: 14,
        key: "",
        pageSize: 10,
        pageNo: 1,
        sortName: "",
        sortValue: "",
        status: -1,
      })
      .then((res) => {
        const { code, message, data } = res;
        if (code !== 0) {
          this.$message.error(message);
          return;
        }

        const {
          pagination: { numberRecords },
          result = [],
        } = data;
        // 记录list
        this.tableData = result;
        // 总条数
        this.total = numberRecords;
      })
      .finally(() => {
      });
  }
}
