import ReconnectingWebSocket from "reconnecting-websocket";

const HeartbeatValue = 0;

export default class Sse extends EventTarget {
  constructor() {
    super();
    this.sseSource = null;
    this.isConnection = false;
    this.pingType = pingType;
  }

  /**
   * 初始化sse
   * @param url
   */
  init(url) {
    const socket = new ReconnectingWebSocket(url);
    this.sseSource = socket;
    this._bindEvent();
  }

  _bindEvent() {
    if (!this.sseSource) return false;
    this.sseSource.onopen = event => {
      console.log("onopen event");
      if (!this.isConnection) {
        this.dispatchEvent(new CustomEvent("opened"));
        this.isConnection = true;
      }
    };
    this.sseSource.onmessage = event => {
      const message = event.data;
      if (message) {
        try {
          const data = JSON.parse(message);
          if (data.type === HeartbeatValue) {
            console.log(data.msg, "heartbeat");
          } else {
            this._messageEvent({ detail: data });
          }
        } catch(e) {
          console.info(message);
        }
      }
    };
    this.sseSource.onclose = err => {
      const { code } = err;
      if (code === 1000) {
        this.dispatchEvent(new CustomEvent("close"));
        this.close();
        console.log(`服务器关闭【${code}】`);
      }
    };
    this.sseSource.onerror = error => {
      this._errorEvent({ detail: error });
    };
  }

  sendMessage(message) {
    if (this.isConnection) {
      this.sseSource.send(message);
    }
  }

  _messageEvent(message) {
    this.dispatchEvent(new CustomEvent("message", message));
  }

  _errorEvent(err) {
    this.dispatchEvent(new CustomEvent("error", err));
  }

  close() {
    if (!this.sseSource) return false;
    this.sseSource.close();
    this.sseSource = null;
    this.isConnection = false;
  }
}
